/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ScrollableListWidget<T, W extends Widget>
extends ContainerWidget {
    private final WidgetFactory<T, W> factory;
    private final List<T> data;
    private int scrollIndex;
    private int pageSize;
    private boolean showScrollbar;
    private int entryHeight = 20;

    public ScrollableListWidget(int x, int y, int width, int height, List<T> data, WidgetFactory<T, W> factory) {
        super(x, y, width, height);
        this.data = data;
        this.factory = factory;
        this.showScrollbar = true;
    }

    public void setScrollbarVisible(boolean visible) {
        this.showScrollbar = visible;
        this.init();
    }

    public void setEntryHeight(int height) {
        this.entryHeight = Math.max(1, height);
        this.init();
    }

    @Override
    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
        if (this.showScrollbar && this.data.size() > this.pageSize) {
            int dataSize = this.data.size();
            double step = (double)this.field_230689_k_ / (double)dataSize;
            int min = MathHelper.func_76128_c((double)((double)this.scrollIndex * step));
            int max = MathHelper.func_76128_c((double)((double)(this.pageSize + this.scrollIndex) * step));
            int x1 = this.field_230690_l_ + this.field_230688_j_ - 5;
            int x2 = x1 + 5;
            int y1 = this.field_230691_m_ + min;
            int y2 = this.field_230691_m_ + max;
            ScrollableListWidget.func_238467_a_((MatrixStack)stack, (int)x1, (int)this.field_230691_m_, (int)x2, (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
            ScrollableListWidget.func_238467_a_((MatrixStack)stack, (int)x1, (int)y1, (int)x2, (int)y2, (int)-7829368);
            ScrollableListWidget.func_238467_a_((MatrixStack)stack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y2 - 1), (int)-1118482);
            ScrollableListWidget.func_238467_a_((MatrixStack)stack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)-3355444);
        }
        ITextComponent text = this.func_230458_i_();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (this.data.isEmpty() && text != null) {
            int textFieldWidth = this.field_230688_j_ - 10;
            List lines = font.func_238425_b_((ITextProperties)text, textFieldWidth);
            int lineCount = lines.size();
            int textHeight = lineCount * 10;
            float textY = (float)this.field_230691_m_ + (float)(this.field_230689_k_ - textHeight) / 2.0f;
            for (int i = 0; i < lineCount; ++i) {
                IReorderingProcessor processor = (IReorderingProcessor)lines.get(i);
                float textX = (float)(this.field_230690_l_ + 5) + (float)(textFieldWidth - font.func_243245_a(processor)) / 2.0f;
                font.func_238422_b_(stack, processor, textX, textY + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.scrollIndex = (int)((double)this.scrollIndex - amount);
            this.clampScrollIndex();
            this.init();
            return false;
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    private void init() {
        this.clear();
        this.pageSize = this.field_230689_k_ / this.entryHeight;
        this.clampScrollIndex();
        boolean scrollbarVisible = this.showScrollbar && this.data.size() > this.pageSize;
        for (int i = this.scrollIndex; i < this.scrollIndex + this.pageSize && i < this.data.size(); ++i) {
            T element = this.data.get(i);
            int renderIndex = i - this.scrollIndex;
            W widget = this.factory.createWidget(element, this.field_230690_l_, this.field_230691_m_ + renderIndex * this.entryHeight, scrollbarVisible ? this.field_230688_j_ - 5 : this.field_230688_j_, this.entryHeight);
            this.addWidget(widget);
        }
    }

    private void clampScrollIndex() {
        this.scrollIndex = Math.max(MathHelper.func_76125_a((int)this.scrollIndex, (int)0, (int)(this.data.size() - this.pageSize)), 0);
    }

    @FunctionalInterface
    public static interface WidgetFactory<T, W extends Widget> {
        public W createWidget(T var1, int var2, int var3, int var4, int var5);
    }
}

